using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace karte3
{
    class Program
    {
        static void Main()
        {
            int n = int.Parse(Console.ReadLine());
            var a = Array.ConvertAll(Console.ReadLine().Split(), long.Parse);

            var prefixSum = new long[n + 1];
            var mapaPozicija = new Dictionary<long, List<int>>();

            mapaPozicija[0] = new List<int> { 0 };

            for (int i = 0; i < n; i++)
            {
                prefixSum[i + 1] = prefixSum[i] + a[i];
                if (!mapaPozicija.ContainsKey(prefixSum[i + 1]))
                    mapaPozicija[prefixSum[i + 1]] = new List<int>();
                mapaPozicija[prefixSum[i + 1]].Add(i + 1);
            }

            int najboljaBalansiranost = 0;

            foreach (var lista in mapaPozicija.Values)
            {
                for (int i = 0; i < lista.Count; i++)
                {
                    for (int j = i + 1; j < lista.Count; j++)
                    {
                        int levo = lista[i];
                        int desno = lista[j];
                        var frekvencije = new Dictionary<long, int>();
                        int lokalniMax = 0;
                        for (int k = levo; k < desno; k++)
                        {
                            if (!frekvencije.ContainsKey(a[k]))
                                frekvencije[a[k]] = 0;
                            frekvencije[a[k]]++;
                            lokalniMax = Math.Max(lokalniMax, frekvencije[a[k]]);
                        }
                        najboljaBalansiranost = Math.Max(najboljaBalansiranost, lokalniMax);
                    }
                }
            }

            Console.WriteLine(najboljaBalansiranost);
        }
    }

}